#pragma once
#include "Model.h"
#include "Sphere.h"
#include "SpotLight.h"

class PoolTable : public Model
{
	public:
		PoolTable();
		~PoolTable();

		//Overrides
		bool loadMTL(char* modelFilename, char* mtlFilename, int renderingShape = GL_TRIANGLES) override;
		void render(Vector3 position = Vector3(5.0f, 1.0f, -4.0f)) override;

		void setSpotlights(SpotLight* one, SpotLight* two);	//Sets the spotlights that affect the pool table's shadow

	private:
		Sphere _PoolBalls[15];	//Pool Balls
		Model _PoolLight;	//Model of the overhanging light

		//Shadow lights
		SpotLight* _SpotOne;
		SpotLight* _SpotTwo;
};

